package doABC;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;

import FlashReader.SwfTools;

public class Instruction extends SwfTools{
	
	public int position; //oriented
	
	//struktory
	protected int opcode; //u8
	protected byte[] operands;
	
	public Instruction(int opcode, byte[] operands){
		this.opcode = opcode;
		this.operands = operands;
	}
	
	public Instruction(int opcode, byte[] operands, int position){
		this.opcode = opcode;
		this.operands = operands;
		this.position = position;
	}
	
	public ByteBuffer getBytes(){
		//alokuj odpowiedni ilo dla wczytanego pliku
		ByteBuffer bbuf = ByteBuffer.allocate(1+operands.length);
		//Ustawiam kolejno bitw na LITTLE ENDIAN
		bbuf.order(ByteOrder.LITTLE_ENDIAN);
		bbuf.put((byte) opcode);
		if (operands.length>0){
			bbuf.put(operands);
		}
		
		return bbuf;
	}
	
	public ArrayList<Byte> getBytes2(){
		ArrayList<Byte> result = new ArrayList<Byte>();
		result.add((byte) opcode);
		if (operands.length>0){
			for (byte b : operands){
				result.add(b);
			}
		}
		return result;
	}

	public int getOpcode() {
		return opcode;
	}

	public byte[] getOperands() {
		return operands;
	}

	
}
